function [grid] = makeRegionSprings(grid)


vert_ind = grid.spring.region_ctrl_pt_ind;
N = size(grid.spring.vert,1);
vert = grid.spring.vert;


for i=1:grid.num_regions
    regind = vert_ind{i};
    regind = cat(1, regind, regind(1));
    for j=1:length(regind)-1
        p1_ind = regind(j);
        p2_ind = regind(j+1);
        len = norm(vert(p1_ind, :) - vert(p2_ind,:));
        grid.spring.len_mat(p1_ind, p2_ind) = len;
        grid.spring.adj_mat(p1_ind, p2_ind) = i;
        grid.spring.len_mat(p2_ind, p1_ind) = len;
        grid.spring.adj_mat(p2_ind, p1_ind) = i;
    end
end
return;