function varargout = SATWarpParamsDlg(varargin)
% function SATWarpParamsDlg
%
% A small utility that allows the user to select some plot options before
% displaying the ungrowth data.
%
% Usage: 
%
% >>SATWarpParamsDlg
%
% Dr. A. I. Hanna, CMP & JIC, Norwich, UK, 2008.

%% initialize the utility
%if checkSATDir(pwd) == 0
%    fprintf('You are not in a valid SectorAnalysisToolbox Project directory\n');
%    return;
%end
% Open, move, and get the handles from the figure file.
data = parseargs(varargin);

fig = openfig(mfilename, 'reuse');
movegui(fig, 'center');
set(fig, 'Visible', 'on');

ad.figMain = fig;
ad.handles = guihandles(fig);

% Set all the callback functions
ad = setupCallbacks(ad);
ad.data = data.warpparams;
setappdata(0,'SATWarpParamsDlg',ad);
initGui;
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
ad = getappdata(0,'SATWarpParamsDlg');
varargout{1} = ad.data;
return;
%
% init the gui values
function initGui
ad = getappdata(0,'SATWarpParamsDlg');
set(ad.handles.xspace_txt, 'String', num2str(ad.data.xspace));
set(ad.handles.yspace_txt, 'String', num2str(ad.data.yspace));
set(ad.handles.smoothtxt, 'String', num2str(ad.data.smoothterm));
set(ad.handles.showmatrialchk, 'Value', ad.data.showmaterialvectors);
set(ad.handles.showclones_chk, 'Value', ad.data.showclones);
set(ad.handles.xspace_txt, 'String', num2str(ad.data.xspace));
set(ad.handles.pad_txt, 'String', num2str(ad.data.padval));
set(ad.handles.clonescale_txt, 'String', num2str(ad.data.clonescale));

if strcmpi(ad.data.direction, 'Forward')
    set(ad.handles.forwardradio, 'Value', 1);
    set(ad.handles.backwardradio, 'Value', 0);
else
     set(ad.handles.forwardradio, 'Value', 0);
    set(ad.handles.backwardradio, 'Value', 1);
end
set(ad.handles.rot_txt, 'String', num2str(ad.data.rotval));
setappdata(0,'SATWarpParamsDlg', ad);
return
%
% Set all the callback functions
function ad = setupCallbacks(ad)
set(ad.handles.ok_btn, 'callback', {@ok});
return
%%
function ok(btn, evd)
ad = getappdata(0,'SATWarpParamsDlg');
ad.data.xspace = str2double(get(ad.handles.xspace_txt, 'String'));
ad.data.yspace = str2double(get(ad.handles.yspace_txt, 'String'));
ad.data.smoothterm = str2double(get(ad.handles.smoothtxt, 'String'));
ad.data.showmaterialvectors = get(ad.handles.showmatrialchk, 'value');
ad.data.rotval = str2double(get(ad.handles.rot_txt, 'String'));
ad.data.padval = str2double(get(ad.handles.pad_txt, 'String'));
ad.data.showclones = get(ad.handles.showclones_chk, 'value');
ad.data.clonescale = str2double(get(ad.handles.clonescale_txt, 'String'));

if get(ad.handles.forwardradio, 'value')
    ad.data.direction = 'Forward';
else
    ad.data.direction = 'Backward';
end    
setappdata(0,'SATWarpParamsDlg',ad);
delete(ad.figMain);
return
%%
function wp = initWarpParams
wp.xspace = 20;
wp.yspace = 20;
wp.smoothterm = 0.01;
wp.showmaterialvectors = 0;
wp.showclones = 0;
wp.direction = 'Forward';
wp.rotval = 0;
wp.padval = 1;
return;
%%
%
function data = parseargs(varargin)
varargin = varargin{1};
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to show_region_areal_growth must come param/value in pairs.')
end
data.warpparams = initWarpParams;
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'warpparams'
            data.warpparams = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, ' show_region_areal_growth.  Name was ' varargin{i}])
    end
end
return;