function warpedSectors = warpSectorsViaTriangles(newEdge, oldEdge, oldSectorBoundaries)

debug = 0;

%triA = [1:size(oldEdge,1)]';
%triB = [2:size(oldEdge,1) 1]';
%triC = [ones(size(triA,1),size(triA,2)) * (size(oldEdge,1)+1)];
%tri = [triA triB triC];

tri = csvread([pwd,filesep,'leafFacet.csv']);

oldEdgeCenter = mean(oldEdge);
oldEdgePetCenter = mean(oldEdge(22:29,:));
oldEdges = [oldEdge;oldEdgeCenter;oldEdgePetCenter];
newEdgeCenter = mean(newEdge);
newEdgePetCenter = mean(newEdge(22:29,:));
newEdges = [newEdge;newEdgeCenter;newEdgePetCenter];

if(debug)
    figure(); hold on
    triplot(tri,oldEdges(:,1),oldEdges(:,2))
end

%for each triangle calculate the warp transform
for i = 1:size(tri,1)
    for j = 1:3
        oldTriangle(j,:,i) = oldEdges(tri(i,j),:);
        newTriangle(j,:,i) = newEdges(tri(i,j),:);
    end
    Tinv{i} = cp2tform(oldTriangle(:,:,i), newTriangle(:,:,i), 'affine');
    
end

%for each boundary
for b=1:length(oldSectorBoundaries)
    %for each boundary pixel find the triangle it lies in
    s = oldSectorBoundaries{b};
    x =s(:,1); y = s(:,2);
    
%     figure(3); hold on;
%     plot(x,y,'rx')
%     plot(oldEdge(:,1),oldEdge(:,2),'ro');
    
    %for each triangle
    for i = 1:size(tri,1)
        %otX = [oldTriangle(:,1,i) ;oldTriangle(1,1,i)]
        %otY = [oldTriangle(:,2,i) ;oldTriangle(1,2,i)]
       [in on] = inpolygon(x,y,oldTriangle(:,1,i),oldTriangle(:,2,i));
       inTri(:,i) = or(in,on);
    end
    for j = 1:size(inTri,1)
        inTriIdxs(j,:) = max(find(inTri(j,:)==1));
    end
    
    for j = 1:size(inTri,1)
        [xm(j), ym(j)] = tformfwd(Tinv{inTriIdxs(j,:)}, x(j), y(j));
        
    end
    
     %figure(3); hold on
     %plot(xm,ym,'bx')
     %plot(newEdge(:,1),newEdge(:,2),'bo');
    
    warpedSectors{b} = [xm(:), ym(:)];
    
    %hurts me to have to so this...
    clear inTri xm ym
    %cla
    
end


% 
% figure(1); hold on
% plot(oldEdge(:,1),oldEdge(:,2),'ro');
% plot(oldEdgeCenter(:,1),oldEdgeCenter(:,2),'rx');
% figure(2); hold on
% triplot(tri,oldEdges(:,1),oldEdges(:,2))
% figure(1);
% plot(newEdge(:,1),newEdge(:,2),'bo');
% plot(newEdgeCenter(:,1),newEdgeCenter(:,2),'bx');
% 
% plot(oldTriangle(:,1,1),oldTriangle(:,2,1),'r')
% plot(newTriangle(:,1,1),newTriangle(:,2,1),'b')
% 
% plot(oldTriangle(:,1,20),oldTriangle(:,2,20),'r')
% plot(newTriangle(:,1,20),newTriangle(:,2,20),'b')
% 
% plot(oldTriangle(:,1,50),oldTriangle(:,2,50),'r')
% plot(newTriangle(:,1,50),newTriangle(:,2,50),'b')
% 
% figure(2)
% for k = 1:size(oldTriangle,3)
%     mp = mean(oldTriangle(:,:,k));
%     text(mp(:,1),mp(:,2),num2str(k))
% end



end
