function [w, orig, im, binim, snew] = JRK_sectors(im, w, binim)
orig = im;
if nargin<3
    binim = calc_binim(im);
end
if(sum(binim(:)) == 0)
    fprintf('Error with the binary image\n');
    orig = zeros(size(im));
    snew = zeros(size(im));
    return;
end
waitbar(1/50, w);
b = im(:,:,3);
snew = b<100;
snew = bwfill(snew, 'holes');
snew = imclose(snew, strel('disk', 2));
im = add_spots(orig, snew, [0 0 1]);
%%%
%
%%%
function [binim] = calc_binim(im)
r = im(:,:,1);
g = im(:,:,2);
b = im(:,:,3);
binim = (b-g)>40;
binim = imclose(binim, strel('disk', 5));
binim = bwfill(binim, 'holes');
return;
%%%
%
%%%
function [im] = add_spots(im, spots, col)
if (nargin == 2)
    col = [1 0 0];
end
ind = find(spots == 1);
imr = im(:,:,1);
img = im(:,:,2);
imb = im(:,:,3);
imr(ind)=col(1);
img(ind)=col(2);
imb(ind)=col(3);
im(:,:,1) = imr;
im(:,:,2) = img;
im(:,:,3) = imb;

