function [w, orig, im, binim, snew] = get_sector(im, w, binim)

im = double(im);
im = im./max(im(:));
im = uint8(im.*255);
im = double(im);
im = im./max(im(:));
orig = im;
im = imadjust(im, stretchlim(im));
if nargin<3
    binim = calc_binim(im);
end
if(sum(binim(:)) == 0)
    fprintf('Error with the binary image\n');
    orig = zeros(size(im));
    snew = zeros(size(im));
    return;
end
waitbar(1/50, w);
snew = im(:,:,1) > .7;
snew = bwfill(snew,'holes');
snew = imdilate(snew, strel('disk', 2));
snew = bwareaopen(snew, 10);
snew = snew & binim;
im = add_spots(orig, snew, [0 0 1]);

function [binim] = calc_binim(im);
%p = imadjust(im(:,:,1), stretchlim(im(:,:,1)));
%binim = normim(p) > .4;
binim = im(:,:,2)>.7;
binim = imclose(binim, strel('disk', 40));
binim = bwfill(binim,'holes');
binim = imdilate(binim, strel('disk', 2));
return;

function [im] = add_spots(im, spots, col)

if (nargin == 2)
    col = [1 0 0];
end
ind = find(spots == 1);
imr = im(:,:,1);
img = im(:,:,2);
imb = im(:,:,3);
imr(ind)=col(1);
img(ind)=col(2);
imb(ind)=col(3);
im(:,:,1) = imr;
im(:,:,2) = img;
im(:,:,3) = imb;
