function [springs] = makeShapeSprings(vertices, ind, centroids)

springs = struct([]);
pts = E(:,end-1:end);

for i=1:length(ind)
    rind = ind{i};
    rpts = vertices(rind,:);
    
    rind = [rind; rind(1)];
    
    for j=1:length(rind)-1
        spring.indx = [rind(j), rind(j+1)];
        midpoint = (vertices(j,:) + vertices(j+1,:))/2;
        [val, mind] = min(sqrt(sum((centroids - ones(size(centroids,1),1)*midpoint).^2,2)));
        spring.dist = val(1);
        spring.region = mind(1);
        springs = cat(1, springs, spring);
    end
end
return;