function base_grid = satlib_shrinkMesh(stage_ungrowth_tensors, base_grid)
% function base_grid = satlib_shrinkMesh(stage_ungrowth_tensors, base_grid)
%
% Shrinks the entire mesh to its new estimated size before relaxing the
% springs. This removes some error from the spring relaxation.
%
% Dr. A. I. Hanna, CMP, 2008.
snorm = 0;
for g = 1:size(stage_ungrowth_tensors,3)
    [smax, smin, theta] = gtlib_growthTensor2Params(stage_ungrowth_tensors(:,:,g));
    snorm = snorm + smax + smin;
end
snorm = snorm./(2*size(stage_ungrowth_tensors,3));
pts = base_grid.tri_info.pts;
mu = mean(pts);
pts = pts - ones(size(pts,1),1)*mu;
pts = pts./(snorm);
pts = pts + ones(size(pts,1),1)*mu;
base_grid.tri_info.pts = pts;
return
