%Hanna, 2005

function [algorithm, value] = AlgPicker(varargin)
error(nargchk(0,inf,nargin));
ad.value = 0;
% ad.alg_dir = which('shed_alg_dir.txt');
% if exist(ad.alg_dir, 'file')
%     ad.alg_dir = fileparts(ad.alg_dir);
% else
%     ad.alg_dir = '';
% end
    ad.alg_dir = '';
ad.algorithm = [];
if (mod(length(varargin),2) ~= 0) && (length(varargin)<6)
    % input args have not com in pairs, woe is me
    error('Arguments to LISTDLG must come param/value in pairs.')
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'alg_dir'
            ad.alg_dir = varargin{i+1};      
        otherwise
            error(['Unknown parameter name passed to LISTDLG.  Name was ' varargin{i}])
    end
end
if isempty(ad.alg_dir)
    ad.alg_dir = uigetdir(pwd, 'Choose the Directory Containing the Algorithms');
    if ad.alg_dir == 0
        fprintf('User cancelled operation\n');
        return;
    end
end
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.alg_list_panel, 'BackgroundColor'));
% Set all the callback functions
set(handles.ok_btn, 'callback', {@doOk});
set(handles.cancel_btn, 'callback', {@doCancel});
set(handles.alg_list, 'callback', {@doChangeAlgorithm});
set(handles.next_btn, 'callback', {@doNext});
set(handles.prev_btn, 'callback', {@doPrev});

% Initialize the application data structure
ad.figMain = fig;
ad.handles = handles;

setappdata(0,'AlgPickerData',ad);
init_gui;

try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
if isappdata(0,'AlgPickerData')
    ad = getappdata(0,'AlgPickerData');
    algorithm = ad.algorithm;
    value = ad.value;
    rmappdata(0,'AlgPickerData')
else
   algorithm = [];

    % figure was deleted
    value = 0;
end
return;
%%%
%
%%%
function init_gui()
ad =getappdata(0, 'AlgPickerData');
algs = dir([ad.alg_dir, filesep, '*.m']);
if isempty(algs)
    return;
end
algs = {algs.name};
set(ad.handles.alg_list, 'String', algs);
doChangeAlgorithm;
return;
%%%
%
%%%
function doChangeAlgorithm(alg_list, evd)
ad =getappdata(0, 'AlgPickerData');
str = get(ad.handles.alg_list, 'String');
val = get(ad.handles.alg_list, 'Value');
alg_name = str{val};
if ~exist([ad.alg_dir, filesep, alg_name])
    return;
end
[alg_path, alg_name, ext, vers] = fileparts(alg_name);
if exist([alg_name, '.jpg'], 'file')
    I = imread([ad.alg_dir, filesep, alg_name, '.jpg']);
else
    I = zeros(100,100);
end
imagesc(I, 'Parent', ad.handles.image_axis);
axis(ad.handles.image_axis, 'image', 'ij');
set(ad.handles.image_axis, 'XTick', [], 'XTickLabel', [], 'YTick', [], 'YTickLabel', []);
setappdata(0, 'AlgPickerData', ad);
return;
%%%
%
%%%
function doOk(ok_btn, evd)
ad =getappdata(0, 'AlgPickerData');
ad.value = 1;
str = get(ad.handles.alg_list, 'String');
val = get(ad.handles.alg_list, 'Value');
ad.algorithm = str{val};
setappdata(0, 'AlgPickerData', ad);
delete(gcbf);
%%%
%
%%%
function doNext(next_btn, evd)
ad =getappdata(0, 'AlgPickerData');
str = get(ad.handles.alg_list, 'string');
val = get(ad.handles.alg_list, 'value');
if val<length(str)
    val = val+1;
end
set(ad.handles.alg_list, 'value', val);
setappdata(0, 'AlgPickerData', ad);
doChangeAlgorithm;
%%%
%
%%%
function doPrev(prev_btn, evd)
ad =getappdata(0, 'AlgPickerData');
str = get(ad.handles.alg_list, 'string');
val = get(ad.handles.alg_list, 'value');
if val>1
    val = val-1;
end
set(ad.handles.alg_list, 'value', val);
setappdata(0, 'AlgPickerData', ad);
doChangeAlgorithm;
%%%
%
%%%
function doCancel(cancel_btn, evd)
ad =getappdata(0, 'AlgPickerData');
ad.algorithm = [];
ad.value = 0;
setappdata(0, 'AlgPickerData', ad);
delete(gcbf);

