function B = femlib_constructB(G)
% function B = femlib_constructB(G)
%
% Here we are constructing the B matrix used in the integral (B'DB)
%
% Recall:
%            -                                   -
%           |dN1/d_xi   dN2/d_xi   .... dN6/d_xi  |
% Nprime =  |dN1/d_eta  dN2/d_eta  .... dN6/d_eta | 
%           |dN1/d_zeta dN2/d_zeta .... dN6/d_zeta| 
%            -                                   -
% and
% 
% J = Nprime*Xe;
% G = inv(J)*Nprime;
%
%so 
%      -                            -
%     |dN1/d_x  dN2/d_x ....  dN6/d_x|
% G = |dN1/d_y  dN2/d_y ....  dN6/d_y| 
%     |dN1/d_z  dN2/d_z ....  dN6/d_z| 
%      -                            -
%
%      -                                                                                       -
%     |dN1/d_x    0       0     dN2/d_x       0        0        .... dN6/d_x      0          0  |
%     |   0    dN1/d_y    0         0     dN2/d_y      0        ....    0      dN6/d_y       0  |
% B = |   0       0    dN1/dz       0         0     dN2/d_z     ....    0         0      dN6/dz |
%     |   0    dN1/dz  dN1/dy       0      dN2/dz    dN2/dy     ....    0      dN6/dz    dN6/dy |
%     |dN1/dz    0     dN1/dx     dN2/dz      0      dN2/dx     .... dN6/dz       0      dN6/dx |
%     |dN1/dy  dN1/dx     0       dN2/dy   dN2/dx       0       .... dN6/dy     dN6/dx        0 |
%      -                                                                                       -
%
% and our strain vector has elements [e_x, e_y, e_z, e_yz, e_xz, e_xy]'
%
%Dr. A. I. Hanna (2006).
B = zeros(6, 18);
B(1,1:3:end) = G(1,:);
B(2,2:3:end) = G(2,:);
B(3,3:3:end) = G(3,:);
B(4,2:3:end) = G(3,:);
B(4,3:3:end) = G(2,:);
B(5,1:3:end) = G(3,:);
B(5,3:3:end) = G(1,:);
B(6,1:3:end) = G(2,:);
B(6,2:3:end) = G(1,:);
return;