function [K,f, usedEquations] = femlib_eliminateEquations( K, f, fixedNodes )
% function [K,f, usedEquations] = femlib_eliminateEquations( K, f, fixedNodes )
%
% Here we remove the equations associated with fixedNodes from the global
% stiffness matrix and global force vector.
%
% Dr. A. I. Hanna (2006).
[rows, cols] = size(K);
usedEquations = setdiff(1:rows, fixedNodes);
K = K(usedEquations, usedEquations);
f = f(usedEquations);
end
