function T = femlib_fixTriMesh(T, X)
% function T = femlib_fixTriMesh(T, X)
%
% femlib_fixTriMesh takes in a triangulation and the set of vertices, then for each
% triangle it reorders the indices to make sure that they are ordered
% clockwise.
%
% Dr. A. I. Hanna (2006)
for i=1:size(T,1)
    t = T(i,:);
    pts = X(t, :);
    [rpts, ind] = femlib_orderVertices(pts);
    T(i,:) = t(ind);
end
return
