function D = femlib_getMaterialStiffnessMatrix(E, v)
% function D = femlib_getMaterialStiffnessMatrix(E, v)
% 
% This function takes the Youngs modulus (E) and Poissons ratio (v) and
% constructs a stiffness matrix. It assumes that the materials in the model
% are make of homogenous material.
%
% Dr. A. I. Hanna

N = 6;
D = zeros(N, N);
D(1:3,1:3) = v;
D(1:7:3*6) = 1-v;
D(4:6, 4:6) = ((1-2*v)/2)*eye(3,3);
D = (E/((1+v)*(1-2*v)))*D;

return;