function femlib_updateMeshPlot(X, elements, dorsalDivide, ph, axish)
% function femlib_updateMeshPlot(X, elements, dorsalDivide, ph)
%
% Updates the plot created by femlib_plotMesh, rather than replot the mesh
% we simply replace the X, Y, Z, data in the plot.
%
% Dr. A. I. Hanna (2006).
for i=1:length(ph)
    ind = elements(i).ind;
    ploth = ph{i};
    Xe = X([ind, ind+dorsalDivide],:);
    %set(ploth(1), 'XData',  [Xe([1:3,1],1)], 'YData', [Xe([1:3,1],2)], 'ZData', [Xe([1:3,1],3)]);
    %set(ploth(2), 'XData',  [Xe([4:6,4],1)], 'YData', [Xe([4:6,4],2)], 'ZData', [Xe([4:6,4],3)]);
    %set(ploth(3), 'XData',  [Xe(1,1), Xe(4,1)], 'YData', [Xe(1,2), Xe(4,2)], 'ZData', [Xe(1,3), Xe(4,3)]);
    %set(ploth(4), 'XData',  [Xe(2,1), Xe(5,1)], 'YData', [Xe(2,2), Xe(5,2)], 'ZData', [Xe(2,3), Xe(5,3)]);
    %set(ploth(5), 'XData',  [Xe(3,1), Xe(6,1)], 'YData', [Xe(3,2), Xe(6,2)], 'ZData', [Xe(3,3), Xe(6,3)]);
    set(ploth(1), 'XData',  [Xe(1:3,1)], 'YData', [Xe(1:3,2)], 'ZData', [Xe(1:3,3)]);
    set(ploth(2), 'XData',  [Xe(4:6,1)], 'YData', [Xe(4:6,2)], 'ZData', [Xe(4:6,3)]);
    set(ploth(3), 'XData',  [Xe(1,1), Xe(4,1) Xe(5,1), Xe(2,1)], 'YData', [Xe(1,2), Xe(4,2) Xe(5,2), Xe(2,2)], 'ZData', [Xe(1,3), Xe(4,3) Xe(5,3), Xe(2,3)]);
    set(ploth(4), 'XData',  [Xe(1,1), Xe(4,1) Xe(6,1), Xe(3,1)], 'YData', [Xe(1,2), Xe(4,2) Xe(6,2), Xe(3,2)], 'ZData', [Xe(1,3), Xe(4,3) Xe(6,3), Xe(3,3)]);
    set(ploth(5), 'XData',  [Xe(2,1), Xe(5,1) Xe(6,1), Xe(3,1)], 'YData', [Xe(2,2), Xe(5,2) Xe(6,2), Xe(3,2)], 'ZData', [Xe(2,3), Xe(5,3) Xe(6,3), Xe(3,3)]);
end
xlim = get(axish, 'XLim');
ylim = get(axish, 'YLim');
zlim = get(axish, 'ZLim');

N = 20;
if max(X(:,1))>xlim(2); xlim(2) = max(X(:,1))+N; end;
if min(X(:,1))<xlim(1); xlim(1) = min(X(:,1))-N; end;
if max(X(:,2))>ylim(2); ylim(2) = max(X(:,2))+N; end;
if min(X(:,2))<ylim(1); ylim(1) = min(X(:,2))-N; end;
if min(X(:,3))<zlim(1); zlim(1) = min(X(:,3))-N; end;
if max(X(:,3))>zlim(2); zlim(2) = max(X(:,3))+N; end;

set(axish, 'XLim', xlim, 'YLim', ylim, 'ZLim', zlim);
return;