function T = gtlib_growthParams2Tensor(r1, r2, alpha)
% function T = gtlib_growthParams2Tensor(r1, r2, alpha)
%
% A method that takes the direction of principle growth, together with the
% growth rates along that direction, and along the direction perpendicular
% to that direction and produces a growth tensor T.
%
% Example
% Calculate the growth tensor
%GT = gtlib_growthParams2Tensor(2, 4, (3*pi)/9);
%
% For rigour we perform the reverse process
%[major, minor, theta] = gtlib_growthTensor2Params(GT)
%
% To visualize the growth tensor we make the unit circle
%theta = linspace(0, 2*pi, 200);
%X = [cos(theta); sin(theta); zeros(size(theta))];
% And apply the growth tensor to the data
%D = GT*X;
% %The Art Corner
%
%figure(1); clf; hold on;
%plot3(X(1,:), X(2,:), X(3,:), 'b', 'LineWidth', 2);
%plot3(D(1,:), D(2,:), D(3,:), 'r', 'LineWidth', 2);
%V = D-X;
%N = size(X,2);
%m = 50;
%ind = 1:N/m:N;
%quiver3(X(1,ind), X(2,ind), X(3,ind), V(1,ind), V(2,ind), V(3,ind),0);
%grid on;
%view(2);
%axis image;
%xlabel('X'); ylabel('Y')
%title('Example of an Anisotropic Growth Tensor')
%
% Dr. A. I. Hanna (2007)
if nargin ~=3
    error('Usage: T = growthParams2Tensor(r1, r2, alpha)');
end
T = [r1*cos(alpha)^2 + r2*sin(alpha)^2, (r1-r2)*cos(alpha)*sin(alpha), 0;
    (r1-r2)*cos(alpha)*sin(alpha), r1*sin(alpha)^2 + r2*cos(alpha)^2, 0;
    0 0 0];
return;