function [xw, beta] = mctlib_warpptsxy(varargin)
% function xw = mctlib_warpptsxy(varargin)
%
% Inputs:
% 'xx' - the NxD matrix of data to warp, where D is the number of
%        dimensions, and N is the number of samples.
% 'x0' - the MxD matrix of reference points
% 'y0' - the MxD matrix of template points
% 'lambda' - the regularization parameters (default = 1)
% 'sigma' - the smoothness parameters (default = 1)
%
% Outputs:
% 'xw' - the warped input 'xx' matrix
%
% Dr. A. I. Hanna, CMP, UEA, Norwich, UK, 2008

% parse the inputs
[xx, x0, y0, lambda, sigma] = parseargs(varargin);
% normalise the reference and template point sets
[x0, datax] = mctlib_normalise('pts', x0);
[y0, datay] = mctlib_normalise('pts', y0);
% calculate the velocity (this gives us some measures points)
V = (y0-x0);
% calculate the MCT coefficients
beta = mctlib_CalcParam('x0', x0, 'f', V, 'sigma', sigma, 'lambda', lambda);
% normalise the to-warp point set with respect to the reference point set
[xx0] = mctlib_normalise('pts', xx, 'datax', datax);
% calculate the velocity accordingly
xw = xx0 + mctlib_CalcVel('x0', x0, 'y0', xx0, 'sigma', sigma, 'beta', beta);
% denormalise with respect to the template point set
[xw] = mctlib_denormalise('pts', xw, 'datax', datay);
return;
%%
%
function [xx, x0, y0, lambda, sigma] = parseargs(varargin)
varargin = varargin{1};
error(nargchk(0,inf,nargin));
xx = [];
x0 = [];
y0 = [];
sigma = 1;
lambda = 1;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'xx'
            xx = varargin{i+1};
        case 'x0'
            x0 = varargin{i+1};
        case 'y0'
            y0 = varargin{i+1};
        case 'sigma'
            sigma = varargin{i+1};  
        case 'lambda'
            lambda = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(xx)
    error('Parameter xx must be supplied');
end
if isempty(x0)
    error('Parameter x0 must be supplied');
end
if isempty(y0)
    error('Parameter y0 must be supplied');
end
return;