%function y = boltzmann(bottom, top, tm, slope, x)
 function y = boltzmann(A, tm, k, t)
%
% A - the size of the final shape
% tm - the time the organ reaches its half size
% k - the growth rate
% t - the time (independent)
%
% Example:
%
% t = linspace(0,100,100);
% y = boltzmann(10, .1, -0.06, t);
% figure;
% plot(t, y);
%
% Dr. A. I. Hanna (2007)

y = A - A./(1 + exp(k.*(t - tm)));
%y = bottom + (top-bottom)./(1 + exp((tm-x)./slope));
return;