function gp = boltzmann_smoothing(gp, bdata)
regions = size( gp(1).average_stage_sector_info,1);
for r = 1:regions
    X = [];
    % remember that columns 4 and 5 correspond to L and W, and 6 is theta
    for i=1:length(gp)
        a = gp(i);
        % X(i,:) =  a.average_stage_sector_info(r,4:5);

        X(i,:) =  a.average_stage_sector_info(r,4);

    end
    region_area = X;
    % region_area = pi*X(:,1).*X(:,2);
    region_area = flipud(region_area);
    y = boltzmann(bdata.A, bdata.tm, bdata.k, bdata.stage_times);
    figure(1); clf;
    plot(bdata.stage_times, y);
    P = boltzmann_nonlinear_stage(bdata, region_area);
    y = boltzmann(P(1), P(2), P(3), bdata.stage_times);
    figure(2); clf; hold on;
    plot(bdata.stage_times, y, '.')
    plot(bdata.stage_times, region_area, 'rx');
    scale = flipud((y(:)./region_area));
    X2 = X;
    X2(:,1) = X(:,1).*scale;
    % X2(:,2) = X(:,2).*scale;
    for i=1:length(gp)
        a = gp(i);
        a.average_stage_sector_info(r,4) = X2(i,:);
        gp(i)= a;
    end
    X = [];
    % remember that columns 4 and 5 correspond to L and W, and 6 is theta
    for i=1:length(gp)
        a = gp(i);
        % X(i,:) =  a.average_stage_sector_info(r,4:5);
        X(i,:) =  a.average_stage_sector_info(r,5);
    end
    region_area = X;
    % region_area = pi*X(:,1).*X(:,2);
    region_area = flipud(region_area);
    y = boltzmann(bdata.A, bdata.tm, bdata.k, bdata.stage_times);
    figure(1); clf;
    plot(bdata.stage_times, y);
    P = boltzmann_nonlinear_stage(bdata, region_area);
    y = boltzmann(P(1), P(2), P(3), bdata.stage_times);
    figure(2); clf; hold on;
    plot(bdata.stage_times, y, '.')
    plot(bdata.stage_times, region_area, 'rx');
    scale = flipud((y(:)./region_area));
    scale(isinf(scale)) = 1;
    X2 = X;
    X2(:,1) = X(:,1).*scale;
    % X2(:,2) = X(:,2).*scale;
    for i=1:length(gp)
        a = gp(i);
        ind = find(a.average_stage_sector_info(:, 3)==0);
        for k=1:length(ind)
            if i>1
                na = gp(i-1);
                a.average_stage_sector_info(ind(k), :) = na.average_stage_sector_info(ind(k), :);
            end
        end
        a.average_stage_sector_info(r,5) = X2(i,:);
        gp(i)= a;
    end

    X2
    %    pi*X2(:,1).*X2(:,2)
end
return
