function [scaling_factors] = growth_tensors_to_scaling_factors(growth_params)
% function [scaling_factors] = growth_tensors_to_scaling_factors(growth_params)
%
%
% Dr. A. I. Hanna (2007)

N = length(growth_params);
scaling_factors = cell(N,1);
for i=1:N
    G = growth_params{i};
    num_regions = size(G,3);
    s_max = zeros(num_regions,1);
    s_min = zeros(num_regions,1);
    theta = zeros(num_regions,1);
    for j=1:num_regions
        [s_max(j), s_min(j), theta(j)] = gtlib_growthTensor2Params(G(:,:,j));
    end
    % a fix to stop shrinking
    %
    s_max(s_max<1) = mean(s_max(s_max>1));
    s_min(s_min<1) = mean(s_min(s_min>1));
    % here we make sure that s_max is the principal directed growth rate
    % if it isn't, then we switch and alter the angle by pi/2.
    idx = s_min>s_max;
    if any(idx)
        vals = s_min(idx);
        s_min(idx) = s_max(idx);
        s_max(idx) = vals;
        theta(idx) = theta(idx)+pi/2;
    end
    %
    % end of the fix
    
    scaling_factors{i}.s_max = s_max;
    scaling_factors{i}.s_min = s_min;
    scaling_factors{i}.theta = theta;
end
return;
