
function growthstruct2obj(growthparamsfilename)
% function growthstruct2obj(growthparamsfilename)
%
%
% Dr. A. I. Hanna
%growthparams = load('matlabgrowthdata2.mat');
growthparams = load(growthparamsfilename);

growthparams = growthparams.GROWTHSTRUCT;
s = length(growthparams);
filenameindx = s-1;
filename = 'stage_';
while  (s>=2)
    gparams = growthparams(s);
    ngparams = growthparams(s-1);
    npts = ngparams.vertices;
    ntri = ngparams.tri;
    tri_info = zeros(size(ntri,1),3);
    for i=1:size(ntri, 1)
        doublingtime = gparams.tridata(i,1);
        anisotropy = gparams.tridata(i,2);
        %doublex = sqrt(2*anisotropy);
        %doubley = doublex/anisotropy;
        %rate_x = log2(doublex)/doublingtime;
        %rate_y = log2(doubley)/doublingtime;
        z = gparams.tridata(i,3);      
        % write out rate_x rate_y z
        tri_info(i,:) = [doublingtime, anisotropy, z];
        %tri_info(i,:) = [rate_x, rate_y, z];
    end
    filenamenum = sprintf('%d', filenameindx);
    save_data([filename, filenamenum, '.obj'], npts, ntri, tri_info);
    s = s - 1;
    filenameindx = filenameindx - 1;
end
%%%%%
%
%
%%%%
function save_data(filename, d, T, tri_info)
fprintf('Saving as %s.\n', filename);
if ~isempty(filename)
    fid = fopen(filename,'w');
    for i=1:size(d,1)
        fprintf(fid, 'v %5.5f %5.5f %5.5f\n', d(i,1), d(i,2), 0);
    end
    for i=1:size(T,1)
        fprintf(fid, 'f %d %d %d\n', T(i,1), T(i,2), T(i,3));
    end
    for i=1:size(tri_info, 1)
        fprintf(fid, 'x-growth %d %5.5f %5.5f %5.5f\n', i, tri_info(i,1), tri_info(i,2), tri_info(i,3));
    end
    fclose(fid);
end
return;