function ShowGrowthTool
% function ShowGrowthTool
%
% A tool that shows the result from the ungrowth tool, a widget in the
% sector analysis toolbox.
%
% See also: SectorAnalysisToolbox, UngrowingTool
%
% Dr. A. I. Hanna (2007)

if checkSATDir(pwd) == 0
    fprintf('You are not in a valid SectorAnalysisToolbox Project directory\n');
    return;
end
error(nargchk(0,inf,nargin));
ad.value = 0;
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.uipanel1, 'BackgroundColor'));

% Set all the callback functions
set(handles.finished_btn, 'callback', {@doOk});
set(handles.load_ungrowth_btn, 'callback', {@doLoadUngrowth});
set(handles.ungrow_stage_list, 'callback', {@doChangeStage});
set(handles.next_btn, 'callback', {@doNext});
set(handles.prev_btn, 'callback', {@doPrev});
set(handles.show_ellipse_btn, 'callback', {@doShowEllipsoids});

% Initialize the application data structure
ad.figMain = fig;
ad.StagedDirString = 'Staged';
ad.OriginalsDirString = 'Originals';
ad.ProcessedDirString = 'Processed';
ad.DataDir = [ad.StagedDirString, filesep, 'Data'];
ad.GridDir = [ad.DataDir, filesep, 'Grids'];
ad.UngrowingDataDir = [ad.DataDir, filesep, 'UngrowthData'];
ad.handles = handles;
ad.markerplot_handle = [];
ad.grid_handle = [];
ad.text_handle = [];
ad.ungrowth_params = [];
ad.ungrown_grid = [];
ad.grid_order = [];
ad.grid_name = [];
setappdata(0,'ShowGrowthToolData',ad);
init_gui;

try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
if isappdata(0,'ShowGrowthToolData')
    ad = getappdata(0,'ShowGrowthToolData');
    value = ad.value;
    rmappdata(0,'ShowGrowthToolData')
else
    % figure was deleted
    %value = 0;
end
return;
%%%
%
%%%
function init_gui()
ad =getappdata(0, 'ShowGrowthToolData');
return;
%%%
%
%%%
function doLoadUngrowth(load_ungrowth_btn, evd)
ad =getappdata(0, 'ShowGrowthToolData');
[filename, pathname] = uigetfile('*.mat', 'Load Ungrowth', [ad.UngrowingDataDir, filesep]);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
else
    ungrown_grids = load([pathname, filesep, filename]);
    ad.ungrown_grids = ungrown_grids.ungrown_grids;
    if isfield(ad.ungrown_grids, 'grid_name')
        ad.grid_name = ad.ungrown_grids.grid_name;
    end
    s = {};
    for i=1:length(ad.ungrown_grids); s{i} = num2str(i); end;
    set(ad.handles.ungrow_stage_list, 'String', s);
    set(ad.handles.ungrow_stage_list, 'Value', 1);
    if isempty(ad.ungrown_grids)
        return;
    end
    E = ad.ungrown_grids{1}.shape;
    ad.XLim = round([min(E(:,1))-20, max(E(:,1))+20]);
    ad.YLim = round([min(E(:,2))-20, max(E(:,2))+20]);
    setappdata(0, 'ShowGrowthToolData', ad);
    showgrid(ad.handles.image_axis);
    showgrid(ad.handles.image_axis2);

    disp(['User selected ', fullfile(pathname, filename)])
end
%%%
%
%%%
function doChangeStage(stage_list, evd)
ad =getappdata(0, 'ShowGrowthToolData');
showgrid(ad.handles.image_axis);
showgrid(ad.handles.image_axis2);
setappdata(0, 'ShowGrowthToolData', ad);

function doShowEllipsoids(show_ellipsoids_btn, evd)
ad = getappdata(0, 'ShowGrowthToolData');
if exist([ad.GridDir, filesep, ad.grid_name], 'file') && ~isdir([ad.GridDir, filesep, ad.grid_name])
    show_average_ellipses_all_stages(ad.DataDir, ad.GridDir, ad.grid_name);
else
    show_average_ellipses_all_stages(ad.DataDir);
end
setappdata(0, 'ShowGrowthToolData', ad);
%%%
%
%%%
function showgrid(image_axis)
ad =getappdata(0, 'ShowGrowthToolData');
if isempty(ad.ungrown_grids)
    return;
end
val = get(ad.handles.ungrow_stage_list, 'Value');
ungrown_grid = ad.ungrown_grids{val};
cla(image_axis);
plot_grid(ungrown_grid, image_axis);
axis(image_axis,'image', 'ij', 'tight');
grid(image_axis, 'on');
set(ad.handles.image_axis, 'XLim', ad.XLim, 'YLim', ad.YLim);


% SF = ad.ungrowth_params.scaling_factors{val};
% edge_petal = ad.ungrown_grid{val}.edge_petal;
% edge_petal = ad.ungrown_grid{val}.shape;
% edge_petal = image_sort(edge_petal(:,1), edge_petal(:,2));
% edge_petal = [edge_petal; edge_petal(1,:)];
% order = ad.ungrown_grid{val}.order;
% cla(image_axis);
% display_growth_factors(S, SF, image_axis);
% display_edges(S, E, image_axis);
% display_springs(S,image_axis);
% display_organ_shape(edge_petal, image_axis, [1 0 0], 2);
% axis(image_axis,'image', 'xy', 'tight');
% grid(image_axis, 'on');
% set(ad.handles.image_axis, 'XLim', ad.XLim, 'YLim', ad.YLim);
return
%%%
%
%%%
function doOk(ok_btn, evd)
ad =getappdata(0, 'ShowGrowthToolData');
ad.value = 1;
setappdata(0, 'ShowGrowthToolData', ad);
delete(gcbf);
%%%
%
%%%
function doNext(next_btn, evd)
ad =getappdata(0, 'ShowGrowthToolData');
str = get(ad.handles.ungrow_stage_list, 'string');
val = get(ad.handles.ungrow_stage_list, 'value');
if val<length(str)
    val = val+1;
end
set(ad.handles.ungrow_stage_list, 'value', val);
setappdata(0, 'ShowGrowthToolData', ad);
doChangeStage;
%%%
%
%%%
function doPrev(prev_btn, evd)
ad =getappdata(0, 'ShowGrowthToolData');
str = get(ad.handles.ungrow_stage_list, 'string');
val = get(ad.handles.ungrow_stage_list, 'value');
if val>1
    val = val-1;
end
set(ad.handles.ungrow_stage_list, 'value', val);
setappdata(0, 'ShowGrowthToolData', ad);
doChangeStage;