function [] = transform_tif()
files = FindFilenames('_petal.tif',pwd);
for f = 1:length(files)
    file = files{f};
    [path, file, ext, vers] = fileparts(file);
    if ~exist([path, filesep, 'edge_xy.mat'], 'file')
        file = file(1:end-6);
        petalim_name = [path, filesep, file, '_petal.tif'];
        sectorsim_name = [path, filesep, file, '_sectors.tif'];
        if ~exist([path, filesep, file, '_sectors_orig.tif'])
            [STATUS,MESSAGE,MESSAGEID] = copyfile([path, filesep, file, '_sectors.tif'],[path, filesep, file, '_sectors_orig.tif']);
        end
        sectorsim = imread([path, filesep, file, '_sectors_orig.tif']);
        sectorsim = imresize(sectorsim, .5);
        edge_name = [path, filesep, file, '_edge_xy.mat'];
        petalim = imread(petalim_name);
        petalim = imresize(petalim, [size(sectorsim,1), size(sectorsim,2)]);
        petalim_name = [path, filesep, file, '.JPG'];
        imwrite(petalim, petalim_name, 'JPEG');
        imwrite(sectorsim, sectorsim_name, 'TIFF');
        E = load(edge_name);
        E = E.xy;
        E = ceil(E*.5);
        E = E+1;
        [binim] = make_organ(E, sectorsim);
        E = binim2SortedEdge(binim);
        imwrite(binim, [path, filesep, file, '_organ.tif'], 'TIFF');
        save([path, filesep, 'edge_xy.mat'], 'E');
    end
    fprintf('%d of %d: %s\n', f, length(files), file);
end

function [B] = make_organ(E, I)

B = zeros(size(I));
ind = sub2ind(size(B), E(:,2), E(:,1));
B(ind) = 1;
B = bwfill(B, 'holes');
