function [UngrowthData] = ungrow_assumption_one(R, growth_params, intern_iter, intern_spr_const, extern_iter, extern_spr_const, NM, animate, axis_handle, error_axis_handle)
%function [UngrowthData] = ungrow_assumption_one(R, growth_params, intern_iter, intern_spr_const, extern_iter, extern_spr_const, NM, animate, axis_handle, error_axis_handle)
%
% Dr. A. I. Hanna (2006)

S = R.region_info.Springs.S;
Edgs = R.region_info.Springs.Edgs;
edge_petal = R.region_info.edge_petal;
control_pts = R.region_info.control_pts;
shape = R.region_info.shape;
REGS = R.region_info.REGS;
waitbar_h = waitbar(0,'Ungrowing, please wait...');
for i=1:length(growth_params.growth_params)
    waitbar(i/length(growth_params.growth_params),waitbar_h);
    UngrowthData(i).S = S;
    UngrowthData(i).Edgs = Edgs;
    UngrowthData(i).order = R.region_info.order;
    UngrowthData(i).edge_petal = edge_petal;
    UngrowthData(i).shape = shape;
    UngrowthData(i).control_pts = control_pts;
    UngrowthData(i).REGS = REGS;
   % GP = ad.growth_params.growth_params{i};
    SF = growth_params.scaling_factors(i);
    UngrowthData(i).SF = SF;
    
    %[SF, S, Edgs, edge_petal, shape] = shrink_organ(SF, S, Edgs, edge_petal, shape);

    
    S = warp_springs(S, SF);
    %display_springs(W,ad.handles.imageAxis);
    %set(ad.handles.status_txt, 'String', 'Starting to apply forces');
    animate_internal = animate(1);
    animate_edge = animate(2);
    

    scale_plot = 1;
    [S, ploterr] = relax_springs(S, intern_iter, intern_spr_const, animate_internal, axis_handle, error_axis_handle, scale_plot);
    %set(ad.handles.status_txt, 'String', 'Finished applying forces');
    if NM
        %set(ad.handles.status_txt, 'String', 'Starting unconstrained nonlinear optimisation');
        [S, ploterr] = relax_springs_NM(S, animate_internal, axis_handle);
        %set(ad.handles.status_txt, 'String', 'Finished unconstrained nonlinear optimisation');
    end
    
    
    cla(axis_handle);
    grid(axis_handle, 'on');
    %display_springs(S,ad.handles.imageAxis);
    %display_growth_factors(S, SF, axis_handle);
    Edgs = warp_edges(S, SF, Edgs);
    [Edgs, iter, plotE] = relax_edges(S, Edgs, R.region_info.order, extern_iter, extern_spr_const, animate_edge, axis_handle, error_axis_handle);
    if NM
        %set(ad.handles.status_txt, 'String', 'Starting unconstrained nonlinear optimisation on edges');
        [Edgs, ploterr] = relax_edges_NM(Edgs, S, animate_internal, axis_handle);
        %set(ad.handles.status_txt, 'String', 'Finished unconstrained nonlinear optimisation on edges');
    end
    [shape] = warp_organ_shape(Edgs, S, UngrowthData(i).Edgs, UngrowthData(i).S, UngrowthData(i).order, UngrowthData(i).shape, REGS);
    [control_pts] = warp_control_pts(Edgs, S, UngrowthData(i).Edgs, UngrowthData(i).S, UngrowthData(i).order, UngrowthData(i).control_pts, REGS);

    % need to calculate the rotations for each region now that we have
    % shrunk our grid
    %region_rot_mat = calc_strain_cross_matrix(shape, control_pts, UngrowthData(i).shape, UngrowthData(i).control_pts, REGS);
    
    %display_grid(S, Edgs, R.region_info.order, axis_handle, [1 0 0], 2);
    display_edges(S, Edgs, axis_handle);
    display_springs(S, axis_handle);
    %display_organ_shape(shape, axis_handle, [1 0 0], 2);
end
N =length(growth_params.growth_params)+1;
UngrowthData(N).S = S;
UngrowthData(N).Edgs = Edgs;
UngrowthData(N).order = R.region_info.order;
UngrowthData(N).edge_petal = edge_petal;
UngrowthData(N).shape = shape;
UngrowthData(N).control_pts = control_pts;
UngrowthData(N).REGS = REGS;
UngrowthData(N).SF = SF;
close(waitbar_h);
