function [av_info, ordering] = get_stage_grid_info(stages, organ_grid)
% function [av_info, sectorsizeinfo] = get_stage_grid_info(stages, organ_grid)
%
%
%
% Dr. A. I. Hanna (2007)

% av_info with be a cell array where each element is a cell array
% containing the average information for a particular grid at a particular
% stage. We do this because we want to be able to have different grids for
% different stages.

% we have an average set of sectors for each grid topology, we need only
% the sucessive pairings, so lets say we have xydata for a stage,
av_info = cell(length(stages)-1,1);
ordering = zeros(length(stages)-1,1);
for i=1:length(stages)-1
    curr_stage = stages{i};
    next_stage = stages{i+1};
    curr_stage_ind = getGridId(organ_grid, curr_stage);
    next_stage_ind = getGridId(organ_grid, next_stage);
    av_info_later = calc_average_sector_info_for_organ_grid(organ_grid, curr_stage_ind, next_stage_ind);
    av_info_earlier = calc_average_sector_info_for_organ_grid(organ_grid, next_stage_ind, next_stage_ind);
    av_info{i}.av_info_earlier = av_info_earlier.average_stage_sector_info;
    av_info{i}.av_info_later = av_info_later.average_stage_sector_info;
end
return;

% sectorsizeinfo = [];
% num_stages = length(grid.average_region_info);
% prefix_str = 'Staged\';
% for i=1:length(stages)
%     str = [prefix_str, stages{i}];
%     for j=1:num_stages
%         if strcmp(str, grid.average_region_info{j}.stage)
%             av_info{i} = grid.average_region_info{j}.average_stage_sector_info;
%         end
%     end
% end
% return;

%
% function [av_info, sectorsizeinfo] = get_stage_grid_info(stages, grid_name)
% ad =getappdata(0, 'UngrowingTool');
% av_info = cell(1, length(stages));
% av_info = [];
% sectorsizeinfo = [];
% for i=1:length(stages)
%         info_name = [ad.StagedDirString, filesep, stages{i}, filesep, 'average_sector_info_', grid_name];
%    % info_name = [ad.StagedDirString, filesep, stages{i}, filesep, 'boltzmann_average_sector_info_', grid_name];
%     if exist(info_name, 'file')
%         f = load(info_name);
%         av_info{i} = f.average_sector_info;
%       %  areas = pi*prod(av_info{i}(:,4:5), 2);
%       %  sectorsizeinfo(i).mean_area = mean(areas);
%       %  sectorsizeinfo(i).median_area = f.median_area;
%       %  sectorsizeinfo(i).mode_area = f.mode_area;
%     end
% end
% return;