
stage_dir = 'Staged'
grid_dir = [stage_dir, filesep, 'Data\Grids\'];
grids = dir([grid_dir, '*.mat']);
grids = {grids.name};
[s,v] = listdlg('PromptString','Select a grid:', 'SelectionMode','single', 'ListString',grids);
if v==0
    return;
end

files = dir(stage_dir);
files = {files.name};
files = cleanup_stage_list(files);
ind = [];
for i=1:length(files)
    if ~exist([stage_dir, filesep, files{i}, filesep, 'average_sector_info_', grids{s}])
        ind = [ind; i];
    end
end
files(ind) = [];
[selection,value] = SelectOrderListDlg('ListString', files);
if isempty(selection)
    return;
end

[filename, pathname] = uiputfile('*.xls', 'Pick an Excel file');
if isequal(filename,0) | isequal(pathname,0)
    disp('User pressed cancel')
    return;
else
    disp(['User selected ', fullfile(pathname, filename)])
end

XL = {};
for i=1:length(selection)
    selection{i}
    M = load([stage_dir, filesep, selection{i}, filesep, 'average_sector_info_', grids{s}]);
    M = M.average_sector_info;
    ind = size(XL,1);
    XL{ind+1, 1} = selection{i};
    XL{ind+1, 2} = 'Length';
    XL{ind+2, 2} = 'Width';
    XL{ind+3, 2} = 'Theta';

    for ii=1:size(M,1)
        XL{ind+1,ii+2} = M(ii,4);
        XL{ind+2,ii+2} = M(ii,5);
        XL{ind+3,ii+2} = M(ii,6);
    end
end
xlswrite([pathname, filesep, filename], XL);