% cbar(n, x, MAP)
%
% This function plots a color histogram according to its distance along the
% x-axis. 
%
% params:- x and n are the result of the hist call
%          MAP is the desired color map, if not specified jet is used 
%
% example:
% [x, n] = hist(randn(10000,1), 50);
% map = copper(50);
% cbar(x, n, map);
% axis tight; grid on;
%
% Dr. A. I. Hanna
function [] = cbar(n, x, MAP, axis_h)
if nargin<4
    axis_h = gca;
end
b = bar(axis_h, n,x);
g = get(b, 'Children');
X = get(g, 'XData');
Y = get(g, 'YData');
delete(b);
if (nargin <3) || (size(MAP,1)<size(X,2))
    MAP = jet(size(X,2));
end
for i=1:size(X,2)
   patch(X(:,i), Y(:,i), MAP(i,:), 'Parent', axis_h);  
end