function stage_dir = chooseStage
% function stage_dir = chooseStage
%
% A function to allow the user to select the stage they want to process.
% Only valid for SAT projects.
%
% Dr. A. I. Hanna (2006)
stage_dir = [];
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
% Set up some directory constants
stagedDir = ['Staged'];
d = dir(stagedDir);
str = {d.name};
[str] = cleanup_stage_list(str);
[s,v] = listdlg('Name', 'Stage Selection', 'ListSize', [300 200], 'PromptString','Select a stage to display:','SelectionMode','single','ListString',str);
if v == 0
    fprintf('Sorry not a valid SectorAnalysis project directory\n');
    return;
end
stage_dir =   [stagedDir, filesep,  str{s}];