%
% displays the grid using the order from concavity check
%
% Dr. A. I. Hanna (2005)
function grid_plot_handle = display_grid(S, E, order, image_axis, color, width)
if nargin<1,
    error('Insufficient arguments');
end
if nargin<2
    image_axis = gca;
end
if nargin<3
    color = [0 0 1];
end
if nargin<4
    width = 1;
end
grid_plot_handle = [];
hold(image_axis, 'on');
for i=1:length(order)
    o = order{i};
    y = E(o, end-1);
    x = E(o, end);
    if ~isempty(x)
        x = [x; x(1)];
        y = [y; y(1)];
        grid_plot_handle = cat(2, grid_plot_handle, plot(image_axis, y, x, 'Color', color, 'LineWidth', width));
    end
end
%hold(image_axis, 'off');
