% [marker_handle, line_handle, text_handle] = display_edges(S,E,image_axis)  Display spring mesh
%           S  : spring definition
%           E  : Edge Definition (Actually this is the vertext information)
%  image_axis  : this is the handle to the axis you want to draw to
%         
%    Returns:
%   marker_handle : handle to the markers
%     line_handle : handle to the lines
%     text_handle : handle to the text
%
%        (c)ag rolland2001
%         re-written: Dr. A. I. Hanna (2005)
function [marker_handle, line_handle, text_handle] = display_edges(S,E,image_axis)
if nargin<2,
	error('Insufficient arguments');
end
if nargin<3
    image_axis = gca;
end
line_handle = [];
text_handle = [];
marker_handle = [];
T=size(S,1);
n=1:T;
sc=1;
N=E(:,1:T);
x=E(:,2*T+1).*sc;
y=E(:,2*T+2).*sc;
xc=S(:,2*T+1).*sc;
yc=S(:,2*T+2).*sc;
hold(image_axis, 'on');
for i=1:size(E,1),
   for j=intersect(n,find(N(i,:))),
       line_handle(end+1) =plot(image_axis, [x(i) xc(j)],[y(i) yc(j)], 'o-');
       set(line_handle(end), 'Color','r', 'LineWidth', 1);
   end
   marker_handle(end+1) = plot(image_axis, x(i),y(i),'d', 'MarkerEdgeColor', 'b', 'MarkerFaceColor', 'y');
   %text_handle(end+1) = text(x(i),y(i),num2str(i), 'Parent', image_axis, 'Color', 'b', 'FontSize', 13, 'FontWeight', 'Bold');
end
