function [marker_handle, line_handle, text_handle] = display_springs(S,image_axis, showtext)
% function [marker_handle, line_handle, text_handle] = display_springs(S,image_axis)
if nargin<1,
    error('Insufficient arguments');
end
if nargin<2
    image_axis = gca;
end
if nargin<3
    showtext = 1;
end
line_handle = [];
text_handle = [];
marker_handle = [];
T=size(S,1);
n=1:T;
p=1;
cpt=0;
xnod=[];
ynod=[];
N=S(:,1:T);
L=S(:,T+1:2*T);
x=S(:,2*T+1);
y=S(:,2*T+2);
hold(image_axis, 'on');

for i=n,
    for j=intersect(intersect(1:T,n),find(N(i,:))),
        line_handle(end+1) = plot(image_axis, [x(i) x(j)],[y(i) y(j)],'-');
        set(line_handle(end),'Color','g', 'LineWidth', 1);
    end
    marker_handle(end+1) = plot(image_axis, x(i),y(i),'d', 'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'g');
end
if showtext
for i=n,
    text_handle(end+1) = text(x(i),y(i),num2str(i), 'Parent', image_axis, 'Color', 'k', 'FontSize', 13, 'FontWeight', 'Bold', 'BackgroundColor', 'w');
end
end
hold(image_axis, 'off');
