function d=distance(v,m)
%d=distance(v,m)
%          Find distances between each vector in v to m.
%          Each vector should be stored row by row.
%          Returns a column vector same length as v, containing Euclidean 
%          distance of each vector in v from m.
%
%          (c) Stephen Impey, April 1996
%

% make t be v-sized version of m
t=(m'*ones(1,size(v,1)))';

t=t-v;
d=sqrt(sum((t.*t)')');
