function [algorithm] = get_project_segmentation_algorithm(segmentation_algs_dir);
algorithm = [];
seg_alg_filename = 'segmentation_algorithm.mat';
if ~exist([pwd, filesep, seg_alg_filename]);
    algorithm = AlgPicker('alg_dir', segmentation_algs_dir);
    [algorithm_path, algorithm, alg_ext, alg_vers] =fileparts(algorithm);
    if isempty(algorithm)
        return;
    end
    save(seg_alg_filename, 'algorithm');
else
    algorithm = load(seg_alg_filename);
    algorithm = algorithm.algorithm;
end