function [corners] = layers2corners(R, regs)
figure; hold on; 
show_layers(R);
axis image;
pts = [];
for i=2:length(regs)
    pts = [pts; regs{i}];
end
ind = [];
pts = unique(pts, 'rows'); 
for i=1:size(pts,1)
   p = pts(i,:);
   d = sqrt(sum((pts - ones(size(pts,1),1)*p).^2,2));
   ind_ii = setdiff(find(d<50), i);
   ind_ii = ind_ii(find(ind_ii>i));
   ind = [ind; ind_ii];
end
pts(ind,:) = [];
p_handle = plot(pts(:,1), pts(:,2), 'wo');

x = pts(:,1); y = pts(:,2);
for i=2:size(R,3)
    r = R(:,:,i);
    cla;
    imagesc(r);
    axis image ij; hold on;
    p_handle = plot(pts(:,1), pts(:,2), 'wo');
    [cx, cy, button] = ginput(1);
    corners{i-1} = [];
    c_handle = [];
    while button == 1
        cx = double(cx);
        cy = double(cy);
        d = sqrt(sum(([x, y] - ones(length(x),1)*[cx, cy]).^2,2));
        [val, ind] = min(d);
        corners{i-1} = [corners{i-1}; x(ind), y(ind)];
        c_handle = [c_handle; plot(x(ind), y(ind), 'rs')];
        [cx, cy, button] = ginput(1);
    end
    delete(c_handle);
end
return