function [EDG, VTX, REGS] = layers2vertex_edge(R, Eptl, control_ind, control_pts, showbar)
vertex = [];
edge = [];
edge_petal = [];
if nargin<3
    fprintf('Usage: [vertex, edge] = layers2vertex_edge(R, Eptl, reg_x, reg_y);\n');
    return;
end
if nargin<6
    showbar = 0;
end
Eptl = round(Eptl);
p = R(:,:,1);
% xr=range(find(any(p)));
% yr=range(find(any(p')));
% dx=ceil(diff(xr)/reg_x);
% dy=ceil(diff(yr)/reg_y);
edge_petal = [];
if showbar == 1
    waitbar_h = waitbar(0, 'Calculating grid...');
end

for l = 2:size(R,3)
    r = R(:,:,l);
    edge=[];
    vertex=[];
    mask = imdilate(r, ones(10));
    [y, x] = find(bwperim(mask));
    [in] = find(inpolygon(Eptl(:,1), Eptl(:,2), x, y)==1);
    edge = [edge; Eptl(in,1:2)];
    REGS{l}.edge = in;
    edge_petal = [edge_petal; [Eptl(in,1:2) ones(length(in),1)*l]];
    clear mask;
    c = control_ind{l-1};
    REGS{l}.vertex = c;
    vertex = [vertex; control_pts(c,1), control_pts(c,2)];
    edge = [edge; control_pts(c,1), control_pts(c,2)];
    EDG{l} = unique(edge, 'rows');
    VTX{l} = unique(vertex, 'rows');
    if showbar == 1
        waitbar((i*j)/(reg_x*reg_y), waitbar_h);
    end

end


% 
% for i=1:reg_x,
%     for j=1:reg_y,
%         l = sub2ind([reg_x reg_y],j,i) +1;
%         if l<size(R,3)
%         r = R(:,:,l);
%         if any(r(:))
%             edge=[];
%             vertex=[];
%             mask = imdilate(r, ones(10));
%             [x, y] = find(bwperim(mask));
%             [in] = find(inpolygon(Eptl(:,1), Eptl(:,2), y, x)==1);
%             edge = [edge; Eptl(in,1:2)];
%             edge_petal = [edge_petal; [Eptl(in,1:2) ones(length(in),1)*l]];
%             for k=0:dx,
%                 if ~ r(yr(1)+dy*(j-1)+(1),xr(1)+dx*(i-1)+(k))== r(yr(1)+dy*(j-1)+(1),xr(1)+dx*(i-1)+(k+1)),
%                     if r(yr(1)+dy*(j-1)+(1),xr(1)+dx*(i-1)+(k))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(k),yr(1)+dy*(j-1)+(1)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(k),yr(1)+dy*(j-1)+(1)]);
%                     elseif r(yr(1)+dy*(j-1)+(1),xr(1)+dx*(i-1)+(k+1))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(k+1),yr(1)+dy*(j-1)+(1)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(k+1),yr(1)+dy*(j-1)+(1)]);
%                     end;
%                 end;
%                 if ~ r(yr(1)+dy*(j-1)+(dy),xr(1)+dx*(i-1)+(k))== r(yr(1)+dy*(j-1)+(dy),xr(1)+dx*(i-1)+(k+1)),
%                     if r(yr(1)+dy*(j-1)+(dy),xr(1)+dx*(i-1)+(k))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(k),yr(1)+dy*(j-1)+(dy)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(k),yr(1)+dy*(j-1)+(dy)]);
%                     elseif r(yr(1)+dy*(j-1)+(dy),xr(1)+dx*(i-1)+(k+1))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(k+1),yr(1)+dy*(j-1)+(dy)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(k+1),yr(1)+dy*(j-1)+(dy)]);
%                     end
%                 end;
%             end;
%             for k=0:dy,
%                 if ~ r(yr(1)+dy*(j-1)+(k),xr(1)+dx*(i-1)+(1))== ...
%                         r(yr(1)+dy*(j-1)+(k+1),xr(1)+dx*(i-1)+(1)),
%                     if r(yr(1)+dy*(j-1)+(k),xr(1)+dx*(i-1)+(1))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(1),yr(1)+dy*(j-1)+(k)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(1),yr(1)+dy*(j-1)+(k)]);
%                     elseif r(yr(1)+dy*(j-1)+(k+1),xr(1)+dx*(i-1)+(1))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(1),yr(1)+dy*(j-1)+(k+1)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(1),yr(1)+dy*(j-1)+(k+1)]);
%                     end;
%                 end;
%                 if ~ r(yr(1)+dy*(j-1)+(k),xr(1)+dx*(i-1)+(dx))== ...
%                         r(yr(1)+dy*(j-1)+(k+1),xr(1)+dx*(i-1)+(dx)),
%                     if r(yr(1)+dy*(j-1)+(k),xr(1)+dx*(i-1)+(dx))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(dx),yr(1)+dy*(j-1)+(k)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(dx),yr(1)+dy*(j-1)+(k)]);
%                     elseif r(yr(1)+dy*(j-1)+(k+1),xr(1)+dx*(i-1)+(dx))==1,
%                         edge=cat(1,edge,[xr(1)+dx*(i-1)+(dx),yr(1)+dy*(j-1)+(k+1)]);
%                         vertex=cat(1,vertex,[xr(1)+dx*(i-1)+(dx),yr(1)+dy*(j-1)+(k+1)]);
%                     end;
%                 end;
%             end;
%             E{l} = unique(edge, 'rows');
%             E2{l} = unique(vertex, 'rows');
%             if showbar == 1
%                 waitbar((i*j)/(reg_x*reg_y), waitbar_h);
%             end
%         end
%         end
%     end
% end
% %end
if showbar == 1
    close(waitbar_h);
end
% edge_petal_regions = edge_petal(:,3);
% [edge_petal, ii,jj] = unique(edge_petal(:,1:2), 'rows');
% edge_petal = [edge_petal, edge_petal_regions(ii)];