%
% function modify_extension(start_dir, old_ext, new_ext)
%
%
% Example:
% >>modify_extension(pwd, '.jpg', '.JPG'); % this will change all .jpg
%                                          % files to .JPG files from pwd down.
%
% Dr. A. I. Hanna (2005)
function modify_extension(start_dir, old_ext, new_ext)
if nargin<3
    return;
end
if ~exist(start_dir, 'dir')
    return;
end
files = FindFilenames(old_ext, start_dir);
for f=1:length(files) 
    file = files{f};
    [path, file, ext, vers] = fileparts(file);
    [STATUS,MESSAGE,MESSAGEID] = movefile([path, filesep, file, ext, vers],[path, filesep, file, new_ext, vers]);
    if STATUS == 0
        fprintf('Could not rename %s\n', [path, filesep, file, ext, vers]);
    end
end