function [eh, Y] = plot_ellipse(axis_handle,r)
% function [eh] = plot_ellipse(axis_handle,r)
%
% This function takes an axis handle and a stucture r that contains
% information about an ellipse.
%
% r has structure as follows:
%
% r.Orientation
% r.MajorAxisLength
% r.MinorAxisLength
% r.Centroid
%
% Uses: plot_ellipse_axis
%
% Dr. A. I. Hanna (2005)
if isfield(r, 'growthTensor')
    [eh, Y] = gtlib_plotGrowthTensor('growth_tensor', r.growthTensor, 'offset', r.Centroid, 'Colour', [0 0 0], 'parent', axis_handle);
    return;
end
theta = linspace(0, 2*pi, 100);
x = cos(theta)';
y = sin(theta)';
R = [cos(r.Orientation) -sin(r.Orientation); sin(r.Orientation) cos(r.Orientation)];
e = [x* r.MajorAxisLength, y*r.MinorAxisLength];
e = (R*e')';
e(:,1) = e(:,1) + r.Centroid(1);
e(:,2) = e(:,2) + r.Centroid(2);
eh= plot(axis_handle, e(:,1), e(:,2), '-', 'Color', [1, .502, 0]); 
[ellipse_axis_handle] = plot_ellipse_axis(axis_handle, r, [0 0 0]);
Y = e;
eh = [eh; ellipse_axis_handle];