function [T] = removeBadRatioFaces(T, d, ratio)
[rows, columns] = size(T);
remove_ind = [];
figure(1); clf;

triplot(T, d(:,1), d(:,2), 'r');
for triRow = 1:rows
    %Calculate the centeroid
    v1 = [d(T(triRow, 1), :), 0];
    v2 = [d(T(triRow, 2), :), 0];
    ph = plot([v1(1) v2(1)], [v1(2), v2(2)], 'b');
    
    area = norm(cross(v1, v2));
    circum = 2*(norm(v1)+norm(v2));
    if area/circum<ratio
        remove_ind(end+1) = triRow;
    end
end
T(remove_ind,:) = [];