function [sector_info] = sector_im2struct(sectors, ellipfitalg, cellplanes)
% function [sector_info] = sector_im2struct(sectorsim)
%
% A function that takes a binary image and converts it to a structure array
% that contains the ellipse information about the sectors.
%
% Input Params:
%  sectorsim - a binary image that contains sectors
%
% Output Params:
%  sector_info - a structure array where each element contains the ellipse
%                information returned by 'ellipse_fit2d'
%
% Dr. A. I. Hanna (2006)
%
% Uses: ellipse_fit2d
if nargin<2
    ellipfitalg = 'AIH';
end
%L = bwlabel(sectorsim);
%R = regionprops(L, 'PixelList');
sector_info(length(sectors)) = struct('growthTensor',[],'Centroid',[], 'ellipArea', [], 'Area', []);
switch ellipfitalg
    case 'AIH'
         clear cellplanes;
        for j=1:length(sectors)           
            % Notice that PixelList returns actual pixels in the region, it has the
            % form [x, y, z, ...], so no need to reverse as you would when getting
            % the values from an image directly.
            %PL = R(j).PixelList;
            %x = PL(:,1); y = PL(:,2);
            x = sectors{j}(:,2);
            y = sectors{j}(:,1);
            sector_info(j) = fitGrowthTensor([x, y]);
        end
    case 'AG'
        clear cellplanes;
        for j=1:length(sectors)
            % Notice that PixelList returns actual pixels in the region, it has the
            % form [x, y, z, ...], so no need to reverse as you would when getting
            % the values from an image directly.
            %PL = R(j).PixelList;
            %x = PL(:,1); y = PL(:,2);
            x = sectors{j}(:,2);
            y = sectors{j}(:,1);
            sector_info(j) = ellipse_fit2d_ag(x, y);
        end
    case 'EEK'    
            %celldiv(cellplanes)
        zeroAngle = defineAngles; % calculate the angle of the mid-vein relative to the x-axis.             
            ad =getappdata(0, 'SectorWarpingToolData');
      % calculate angles of the division planes relative to the zero line.
      % the angle of the division plane is calculated (wallAngle) and the
      % one perpendicular to it (perpdataAngle) 
    binim = imread(cellplanes);                  
            bwLabels = bwlabeln(binim); 
            xaxisAngle = regionprops(bwLabels, 'Orientation', 'Centroid', 'PixelIdxList', 'Area'); %look at by xaxisAngle.Orientation;    
            %  figure, imshow(binim); hold on;
            clear cellplanes;
        for (i=1:length(xaxisAngle))
            wallAngle = (getfield(xaxisAngle(i,1), 'Orientation')- zeroAngle);  % 
            perpAngle = 90+ (getfield(xaxisAngle(i,1), 'Orientation')- zeroAngle);   
            if (-90 < perpAngle && perpAngle < 90)  % make sure that angles always between -90 and 90 for comparison.
              perpdataAngle = perpAngle;
            elseif (perpAngle > 90)
               perpdataAngle = wallAngle - 180; 
            elseif (wallAngle < -90)
              perpdataAngle= perpAngle + 180;
            end        
            if (-90 < perpAngle && perpAngle < 90)  % make sure that angles always between -90 and 90 for comparison.
              perpdataAngle = perpAngle;
            elseif (perpAngle > 90)
               perpdataAngle = perpAngle - 180; 
            elseif (perpAngle < -90)
              perpdataAngle= perpAngle + 180;
            end  
            %pixelArea = xaxisAngle.PixelIdxList;
            realArea = xaxisAngle.Area;
             c = getfield(xaxisAngle(i), 'Centroid');
             %sector_info = setfield(sector_info, {i}, 'Area', pixelArea);
             sector_info = setfield(sector_info, {i}, 'Area', realArea);
             sector_info = setfield(sector_info, {i}, 'perpdataAngle', perpdataAngle);
             sector_info = setfield(sector_info, {i},'Centroid', c);
             sector_info = setfield(sector_info, {i}, 'wallAngle', wallAngle);
%            text(coordall(1), coordall(2), num2str(perpAngle), 'Color', 'r'); hold on; 
        end
    otherwise
        fprintf('Unknown ellipse fitting algorithm\n');
end
return;
% for j=1:length(sectors)
%     % Notice that PixelList returns actual pixels in the region, it has the
%     % form [x, y, z, ...], so no need to reverse as you would when getting
%     % the values from an image directly.
%     %PL = R(j).PixelList;
%     %x = PL(:,1); y = PL(:,2);
%     x = sectors{j}(:,2);
%     y = sectors{j}(:,1);
%      switch ellipfitalg
%         case 'AIH'
%             sector_info(j) = fitGrowthTensor([x, y]);
%             %sector_info(j) = ellipse_fit2d([x, y]);
%         case 'AG'
%             sector_info(j) = ellipse_fit2d_ag(x, y);
%         otherwise
%             fprintf('Unknown ellipse fitting algorithm\n');
%     end
% end
% return