function show_aligned_edges
% function show_aligned_edges
%
% Find all the files with name 'edge_aligned_xy.mat' from the current
% directory down and plots the shape. You can right click on the shapes to
% display their names
%
% Example:
%
% show_aligned_edges
%
% Dr. A. I. Hanna (2007)
if ~checkSATDir(pwd)
    str = sprintf('This is not a valid SAT project.\nPlease change directory in Matlab');
    uiwait(msgbox(str,'Invalid Project','modal'));
    return
end
prj_name = pwd;
[a, prj_name] = fileparts(prj_name);
files = FindFilenames('edge_aligned_xy.mat', 'Staged');
[figh, ah, shapeuimenu] = newFig;
for i=1:length(files)
    if mod(i,100)==0
      [figh, ah, shapeuimenu] = newFig;
    end
    aligned_edge = load([pwd, filesep, files{i}]);
    aligned_edge = aligned_edge.edge_aligned_xy;
    data.name = fileparts(files{i});
    aligned_edge = [aligned_edge; aligned_edge(1,:)];
    plot(ah, aligned_edge(:,2), aligned_edge(:,1), 'UIContextMenu', shapeuimenu, 'UserData', data);
    axis image ij;
end
title(['Aligned Shapes for Project ', prj_name], 'Interpreter', 'none'); 
set(gcf, 'Name', ['Aligned Shapes for Project ', prj_name]);
%%%
%
%%%
function showShapeName(a, b)
d = get(gco, 'UserData');
d.name
return
%%%
%
%%%
function [figh, ah, shapeuimenu] = newFig
figh = figure;
ah = gca;
hold(ah, 'on');
grid(ah, 'on');
shapeuimenu = uicontextmenu('Parent', figh);
uimenu(shapeuimenu,'Label','Shape Name','callback',{@showShapeName});
return;