[filename, pathname] = uigetfile('*.mat', 'Pick an M-file');
if isequal(filename,0) | isequal(pathname,0)
    disp('User pressed cancel')
else
    disp(['User selected ', fullfile(pathname, filename)])
    L = load([pathname, filesep, filename]);
end
for stage=1:length(L.growth_parameters.scaling_factors)
    S = L.ungrown_grid(stage).S;
    l = L.growth_parameters.scaling_factors(stage);
    figure; clf;
    hold on;
    centroids = S(:,end-1:end);
    scale = 10;
    for i=1:size(centroids,1)
        c.Centroid(1) = centroids(i,2);
        c.Centroid(2) = centroids(i,1);
        c.MajorAxisLength = l.s_max(i)*scale;
        c.MinorAxisLength = l.s_min(i)*scale/2;
        c.Area = l.s_max(i)*scale;
        c.Orientation = l.theta(i);
        plot_ellipse(gca, c);
    end
    axis image ij;
end


