function [control_pts] = warp_control_pts(Enew, Snew, Eold, Sold, order, control_pts, REGS)
for i=1:size(control_pts,1)
    ii = 2;
    r = [];
    while isempty(r) & (ii<=length(REGS))
      region = REGS{ii};
      if any(region.vertex==i)
          r = ii;
      end
      ii = ii + 1;
    end
    if iscell(order) & (length(order)<=r)
        order = order{r};
    else
        order = [];
    end
    if isempty(r)
        cent = Sold(:, end-1:end);
        p = control_pts(i,:);
        [val, r] = min(sqrt(sum((cent - ones(size(cent,1),1)*p).^2,2)));
        r = r+1;
    end    
    [xnew, ynew] = get_region_vertices(Enew, Snew, r-1, order);
    [xnew, ynew] = interp_vertex_points(xnew, ynew);
    [xold, yold] = get_region_vertices(Eold, Sold, r-1, order);
    [xold, yold] = interp_vertex_points(xold, yold);
%     figure(1); clf; hold on;
%     plot(xnew, ynew, 'ro');
%     plot(xold, yold, 'go');
    T = cp2tform([xnew, ynew], [xold, yold],'polynomial', 2);
    u = double(control_pts(i,1));
    v = double(control_pts(i,2));
    control_pts(i,:) = [ones(length(u),1)  u  v  u.*v  u.^2  v.^2]*T.tdata;
end