function KparKperModel(aam)
    Cwd=pwd;
    [tempprojectpath, aamModelType] = fileparts(Cwd);
    projectname='GPT_ArLeaf_110323A';
    %projectpath='D:\ab\Matlab stuff';
    projectpath='C:\MATLAB';
    [FileName,PathNameA] = uigetfile(fullfile('..','*.m'),...
        'Select GFtbox project interaction function m file',fullfile(projectpath,projectname,[lower(projectname),'.m'])) ;
    if ischar(FileName)
        [projectpath, projectname] = fileparts(PathNameA(1:end-1));
    end
        
    %projectname = uigetdir(projectpath,'Select the GFtbox project folder');
    
    template=get(aam,'PointModelTemplate');
    modelDirec=get(aam,'modelDirec');
    [pathstr, name, ext]=fileparts(modelDirec);
    [pathstr, name, ext]=fileparts(pathstr);
    [pathstr, setname, ext]=fileparts(pathstr);
    pointmodelsdirectory=fullfile('PointModels',name);
    [Data,latest_outputs_from_model]=ReadGFtboxMonitor(projectpath,projectname,template,pointmodelsdirectory);
    % map the 3D vertices in ModelledVertices to the 2D pts that form the
    % pointmodels
    % read the connectedPts from the file
    facetName=[setname,'-correspondences.csv'];
    facetPathName=fullfile(Cwd,'Templates');
    if strcmpi(aamModelType,'PRJ_ArabLeafShapePaulSimpFlat')
        connectedPts = csvread(fullfile(facetPathName,facetName));
    end
    for i=1:length(Data)
        offsetVerticesA=Data(i).ModelledVertices; % remove all negative numbers
        mins=min(offsetVerticesA);
        offsetVertices=offsetVerticesA-repmat(mins,size(offsetVerticesA,1),1);
        pts3D = reshape(offsetVertices',1,prod(size(Data(i).ModelledVertices)));
        pts3D = pts3D';
        Dirpointmodels=fullfile('PointModels',setname);
        DirCropped=fullfile('Cropped',setname);
        
        if strcmpi(aamModelType,'PRJ_ArabLeafShapePaulSimpFlat')
            pts2cols = midToEdgeDistanceModel(pts3D,connectedPts,'simple');
            %reshape for saving
            pts = reshape(pts2cols',1,size(pts2cols,1)*2)';
        elseif strcmpi(aamModelType,'PRJ_ArabidopsisLeafShape')
            pts = pts3D;     
        else
            error('aamModelType not recognised in KparKperModel()');
        end
        %pts = pts';
        SavePointModels(pts,Cwd,Data(i),Dirpointmodels,projectname,latest_outputs_from_model);
        %SaveCroppedImages(pts2cols,Cwd,Data(i),DirCropped,projectname,latest_outputs_from_model);
        disp(sprintf('Saved %d out of %d',i,length(Data)));
    end
end