function augment_info = getAugmentInfo(s, projs)
augment_info = struct([]);
for i=1:length(s)
   augment_info(i).projectdir = projs{s(i)};
   augment_info(i).templatename = selectTemplate(projs{s(i)});
   [pmfiles, pointmodel] = getPMList(augment_info(i).projectdir, augment_info(i).templatename);
   augment_info(i).pmfiles = pmfiles;
   augment_info(i).pointmodel = pointmodel;
   templatefilename = [augment_info(i).projectdir, filesep, 'Templates', filesep, augment_info(i).templatename];
   if exist(templatefilename)
       template = load(templatefilename, '-mat');
       template = template.PMTemplate;
   else
       template = [];
   end
   augment_info(i).template = template;
end