function [type] = getProjectType(projectDir)
% [type] = getProjectType(projectDir)
% 
% Description:
% A function to determine the type of the project 
% 
% Author: Johann Strasser
% Date: 070312

type = 'project2D';
files = dir(fullfile(projectDir, '*.type'));
noOfTypeFiles = length(files);

if noOfTypeFiles > 1
    error(['Project must have zero or one .type file. ', ...
        'Number of .type files found: %i.'], noOfTypeFiles);
elseif noOfTypeFiles == 1
    [pathstr, name, ext] = fileparts(files(1).name);
    type = name;
    
    % The following is reserved for future use. We may want to keep
    % additional information about the project in this file
%     typeStruct = load(fullfile(projectDir, files(1).name), '-mat');   
end
