function pcalib_plotshape(x, c, axis_h)
% function pcalib_plotshape(x, c, axis_h)
%
% A simple script to plot the shape given in the column vector x.
%
% Inputs:
%  x - a column vector of the form x = [x_1, y_1, x_2, y_2, ..., x_N, y_N]';
%  c - the color to plot the shape (default: c = [0 0 1])
%  axis_h - the handle of the axis to plot the shape (default: axis_h = gca)
%
% Dr. A. I. Hanna (2006)

if nargin<2
    c = [0 0 1];
end
if nargin<3
    axis_h = gca;
end
x = reshape(x, 2, length(x)/2);
plot(axis_h, x(1,:), x(2,:), '-o', 'MarkerSize', 2, 'MarkerEdgeColor', c, 'MarkerFaceColor', 'none');