%%%%%%%%%%%%%%%%%%%%%%
%
%
%  PlotTemplate(A, template)
%
%%%%%%%%%%%%%%%%%%%%%%
function [plotH] = PlotTemplate(A, in_context, template, handles, plotH)
%function [plotH] = PlotTemplate(A, template, handles, plotH)
%
% Also plot the image
% A, main plotting axis
% in_context, 1 if all points are to be displayed, 0 if only the currently selected points (indexed using indices)
% template (from Data.handles.AAM)
% handles (from Data.handles)
% plotH (a field from Data.handles)
%
%usage
%Data.handles.dat.plotH = PlotTemplate(Data.handles.mainAxes, Data.handles.PointModelTemplate, Data.handles, Data.handles.dat.plotH);
%
%J. A. Bangham, 2010

im=get(template, 'image');
Data.handles.dat.plotimH=imagesc(im,'parent',A,'HitTest', 'on'); 
axis image ij;

% pdm=get(handles.AAM,'pdm');
% if isfield(pdm,'in_context')
%     in_context=pdm.in_context;
% else
%     in_context=1;
% end
I = get(template, 'image');
pts = get(template, 'pts');
pri = get(template, 'primaries');
loops = get(template, 'loops');
edges=loops{1};
closedloops = get(template, 'closedloops');
if isempty(closedloops)
    closedloops = 0;
end
axes(A); hold(A, 'on');

if get(handles.linesChk, 'value')
    
    if ~isfield(plotH,'edges')
        for i=1:size(edges,1)
            plotH.edges(end+1) = plot([pts(1, edges(i,1)),pts(1, edges(i,2))], ...
                [pts(2, edges(i,1)),pts(2, edges(i,2))], '-r', 'LineWidth', 1.5,...
                'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
            %         plotH(length(plotH)+1) = plot([pts(1, edges(i,1)),pts(1, edges(i,2))], ...
            %             [pts(2, edges(i,1)),pts(2, edges(i,2))], '-r', 'LineWidth', 1.5,...
            %             'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
        end
    end
end
if get(handles.landmarksChk, 'value')
    if (size(pts, 2) > 0)
        % handle those points that are part of the currently selected set
        ind_set_pri=intersect(handles.dat.indices,pri);
        ind_set_sec=setdiff(handles.dat.indices,pri);
        pts_set_pri=pts(:,ind_set_pri);
        pts_set_sec=pts(:,ind_set_sec);
        % and those that are not
        ind_not=setdiff(1:length(pts),handles.dat.indices);
        ind_notset_pri=intersect(ind_not,pri);
        ind_notset_sec=setdiff(ind_not,pri);
        pts_notset_pri=pts(:,ind_notset_pri);
        pts_notset_sec=pts(:,ind_notset_sec);
        % plot the selected set points
        if isfield(plotH,'pri_set'), plotH.pri_set=[];end;
        if isfield(plotH,'sec_set'), plotH.pri_set=[];end;
        if isfield(plotH,'pri_notset'), plotH.pri_notset=[];end;
        if isfield(plotH,'sec_notset'), plotH.sec_notset=[];end;
        plotH.pri_set = plot(pts_set_pri(1, :), pts_set_pri(2,:),...
            'h', 'MarkerEdgeColor', 'r', 'MarkerFaceColor', 'w', 'MarkerSize', 9, 'HitTest', 'on');
        plotH.sec_set = plot(pts_set_sec(1, :), pts_set_sec(2,:),...
            'h', 'MarkerEdgeColor', 'g', 'MarkerFaceColor', 'w', 'MarkerSize', 9, 'HitTest', 'on');
        if in_context % and the rest if part of the current model
            plotH.pri_notset = plot(pts_notset_pri(1, :), pts_notset_pri(2,:),...
                'o', 'MarkerEdgeColor', 'r', 'MarkerFaceColor', 'y', 'MarkerSize', 5, 'HitTest', 'on');
            plotH.sec_notset = plot(pts_notset_sec(1, :), pts_notset_sec(2,:),...
                'o', 'MarkerEdgeColor', 'g', 'MarkerFaceColor', 'y', 'MarkerSize', 5, 'HitTest', 'on');
        end
    end
end
% if get(handles.labelsChk, 'value')
%     for i=1:size(pts, 2)
%         plotH(length(plotH)+1) = text(pts(1, i)+2, pts(2,i), num2str(i), 'Color', 'r', 'HitTest', 'off', 'Parent', A, 'Clipping', 'on');
%     end
% end
%axis(A, 'image');
return;