function [ipts,opts] = tri_interp_pts(ipts,opts, TRI)
% function [ipts,opts] = tri_interp_pts(ipts,opts)
%
% A function that makes a triangulation of some input points and then finds
% the center of each of these triangles. A linear conformal warp is set up
% between the input points and the output points that is dependent on the
% trianglulation. The new centers are then warped according to this warp
% giving new output points.
%
% Input Params:
%   ipts - a Mx2 matrix of input points (this will be the one we do the
%          triangulation on.
%   opts - a Mx2 matrix of output points
%
% Output Params:
%   ipts - the interpolated input points
%   opts - the interpolated output points
%
% Dr. A. I. Hanna (2006).
if nargin <2
    fprintf('at least two input matrices must be supplied\n');
    return;
end
if ~all(size(ipts) == size(opts))
    fprintf('input vectors must be of the same size\n');
    return;
end
if nargin<3
TRI = delaunay(ipts(:,1), ipts(:,2),{'QJ','QJ','QJ'});
end
iipts = [];
iopts = [];
for t = 1:size(TRI,1)
    base_pts = [ipts(TRI(t,1:3),1), ipts(TRI(t,1:3),2)];
    ip = tri_center(base_pts);
    base_pts = interp_tri_pts(base_pts);
    target_pts = interp_tri_pts([opts(TRI(t,1:3),1), opts(TRI(t,1:3),2)]);
    T = cp2tform(base_pts, target_pts,'linear conformal');
    [x, y] = tformfwd(T, ip(1), ip(2));
    iipts = [iipts; ip];
    iopts = [iopts; [x y]];
end
ipts = [ipts; iipts];
opts = [opts; iopts];