function VO=VolViewer(handshakeHandle,WatchFileNumber,PathToVolViewer,PathToWatchFile)
    %function VO=VolViewer(handshakeHandle,WatchFileNumber,PathToVolViewer,PathToWatchFile)
    %
    %VolViewer object constructor
    %
    %VO, a VolViewer object
    %handshakeHandle, handle to object the colour of which will signal correct operation of VolViewer
    %
    %WatchFileNumber, if 0 (default) then VolViewer is not launched
    %                    1 VolViewer is launched with WatchFile1.txt
    %                    2 ... WatchFile2.txt
    %PathToVolViewer, default is either
    %                    C:\Program Files\VolViewer
    %                 or
    %                    the PathToVolViewer used in the previous VolViewer object
    %                    (saved data file is in CLASSFILES directory containing @VolViewer)
    %PathToWatchFile, default is either
    %                    pwd (present working directory)
    %                 or
    %                    the PathToWatchFile used in the previous VolViewer object
    %                    (saved data file is in CLASSFILES directory containing @VolViewer)
    %
    %It is assumed that
    %         PathTo is the path to the following files
    %          imageFiles: 
    %          msrFilename: 
    %          tfnFilename: 
    %          slcFilename: 
    %          vvrFilename: 
    %          objFilename: 
    %Usage
    %VOL=VolViewer; % create an object without launching VolViewer
    %VOL=VolViewer(1); % create an object and launch VolViewer
    %
    %J.Andrew Bangham, 2012
    if nargin<1
        handshakeHandle=[];%error('Please give a handle');
    end
    if nargin<2
        WatchFileNumber=0;
    end
    PathToVolViewer=[];
    PathToWatchFile=[];
    Pathname1=fileparts(which('imshowVOL'));
    Drive=Pathname1(1:2);
    Pathname=fullfile(Drive,'VolViewerSupport');
    if exist(Pathname)~=7
        mkdir(Pathname);
    end
    %Pathname=fileparts(Pathname1);
    if nargin<3
        filename=fullfile(Pathname,'PathToVolViewer.txt');
        if exist(filename)==2
            fid=fopen(filename,'r');
            if fid~=0
                PathToVolViewer=fgetl(fid);
                fclose(fid);
            end
        end
        if isempty(PathToVolViewer)
            [discard, PathToVolViewer] = uigetfile('VolViewer.exe','Select VolViewer.exe');
            if exist(filename)==2
                delete(filename);
            end
            fid=fopen(filename,'w');
            if fid~=0
                fprintf(fid,'%s\n',PathToVolViewer);
                fclose(fid);
            end
            filename=fullfile(Pathname,'PathToWatchFile.txt');
            if exist(filename)==2
                delete(filename);
            end
            fid=fopen(filename,'w');
            if fid~=0
                fprintf(fid,'%s\n',Pathname); %PathToVolViewer);
                fclose(fid);
            end
        end
    end
    if nargin<4
        filename=fullfile(Pathname,'PathToWatchFile.txt');
        if exist(filename)==2
            fid=fopen(filename,'r');
            if fid~=0
                PathToWatchFile=fgetl(fid);
                fclose(fid);
            end
        end
    end
    VO.PathToVolViewer={PathToVolViewer};
    VO.PathToWatchFile={PathToWatchFile};
    VO.WatchFileNumber=WatchFileNumber;
    pathWatchFileName=fullfile(VO.PathToWatchFile{1},sprintf('WatchFile%1d.txt',VO.WatchFileNumber));
    pathLogFileName=fullfile(VO.PathToWatchFile{1},sprintf('LogFile%1d.txt',VO.WatchFileNumber));
    % make an empty WatchFile
    if WatchFileNumber~=0
        if exist(pathLogFileName)==2
            delete(pathLogFileName);
        end
        fid=fopen(pathWatchFileName,'w');
        if fid~=-1
            string=sprintf('save_text(''%s'', ''%s'')','0000',fullfile(VO.PathToWatchFile{1},sprintf('WatchMeFile%1d.txt',VO.WatchFileNumber)));
            fprintf(fid,'%s',string);%'set_logfile(''%s'')\n',pathLogFileName);
            fclose(fid);
        end
        % so when VolViewer is launched - the first thing it does is setup the new, empty, logfile and hide the console window
        % Thus, a test for the existence of the logfile should be a test for the ex
        systemString=['"',fullfile(PathToVolViewer,'VolViewer'),'"',...
            sprintf(' set_watchfile(''%s'')',pathWatchFileName),' &'];
        [status result] = system(systemString);
        fprintf(1,'VolViewer: %s\n',systemString);
        if status~=0
            fprintf(1,'Error launching VolViewer: %s\n Install into "Program Files" from BanghamLab web pages\n',result);
        end
    else
        %VO.WatchFileNumber=1;
    end
    VO.PathTo='';
    VO.imageFiles={};
    VO.msrFilename='';
    VO.tfnFilename='';
    VO.slcFilename='';
    VO.vvrFilename='';
    VO.objFilename='';
    VO.timeout=40; % seconds, time to wait for VolViewer to reply on this installation
    VO.current_command_ID={sprintf('%04d',0)};
    VO.Commands={};
    VO.handshakeHandle=handshakeHandle;
    VO=class(VO,'VolViewer');
%   Now save PathToVolViewer and PathToWatchFile to disc - 
%   so that defaults for the copy of VolViewer installed on this computer can be maintained 
    VO=set(VO,'PathToVolViewer',PathToVolViewer,'PathToWatchFile',PathToWatchFile);
 end