function newModelData = midVeinRibViaPlaneModel(oldPts,connectedPts)
debugPlot = 0

%% reshape the data into a useful format
data = reshape(oldPts,3,size(oldPts,1)/3)';

if(debugPlot)
    plot3(data(:,1),data(:,2),data(:,3),'rx');
    for j = 1:size(data,1)
        text(data(j,1),data(j,2),data(j,3),num2str(j))
    end
    axis equal
end

%% get rib points
for i = 1:size(connectedPts,1)
    dataRib(i,:) = data(connectedPts(i),:);
end

if(debugPlot)
    figure();
    plot3(dataRib(:,1),dataRib(:,2),dataRib(:,3),'rx');
    for j = 1:size(dataRib,1)
        text(dataRib(j,1),dataRib(j,2),dataRib(j,3),num2str(j))
    end
    axis equal
end

%% find best fit plane through ribPoints
[c,p,flatness] = bestFitPlane(dataRib);

%% project points onto that plane
p2 = ones(size(dataRib,1),size(dataRib,2));
for i = 1:size(p2,1)
    p2(i,:) = p2(i,:) .* p;
end

for i = 1:size(dataRib,1)
    x(i,:) = dataRib(i,:) - dot(dataRib(i,:),p)*p;
end

if(debugPlot)
    hold on
    plot3(x(:,1),x(:,2),x(:,3),'bx');
    for j = 1:size(dataRib,1)
        text(x(j,1),x(j,2),x(j,3),num2str(j))
    end
    axis equal
end

%% project plane pts into 2d xy space
[v1,v2] = makeframe(p);
xy = x * [v1 ; v2]';



%% translate xy to +ve coords
m = min(xy);
xy(:,1) = xy(:,1) + (ones(size(xy,1),1).*abs(m(1)));
xy(:,2) = xy(:,2) + (ones(size(xy,1),1).*abs(m(2)));

if(debugPlot)
    figure();
    plot(xy(:,1),xy(:,2),'gx');
    for j = 1:size(dataRib,1)
        text(xy(j,1),xy(j,2),num2str(j))
    end
    axis equal
end

%% yay!
newModelData = xy;

end