function [handlelH, model]=PDMWalk_PlotModel(pdm, handlelH, net_offset, showlinesflag, edges)
% Plot model
global triplot_handles
if nargin<2
    handlelH=[];
end
if nargin<3
    net_offset=[0,0]; %
end
if nargin<4
    showlinesflag=0;
    linesH=[];
end
if nargin<5
    edges=[];
end
setedges=pdm.setedges;
edges = setedges;
%[pdm,bW,sd]=modify_weights(pdm);
model = pdm.Xm + pdm.P * pdm.bW; % * pdm.multi;
% if original image is present, offset into image
if nargout==1
    model2.pts(:,1)=model(1:2:pdm.Nvals)+net_offset(1); % offset into display
    model2.pts(:,2)=model(2:2:pdm.Nvals)+net_offset(2);
    model2.subject=pdm.subject;
    if isempty(handlelH)
        hold on
        if ~isempty(edges)
            for e = 1:size(setedges,1)
                handlelH(length(handlelH)+1) = plot(...
                    [model2.pts(setedges(e,1),1),model2.pts(setedges(e,2),1)], ...
                    [model2.pts(setedges(e,1),2),model2.pts(setedges(e,2),2)], ...
                    '-r', 'LineWidth', 2.5, 'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
%                 handlelH(length(handlelH)+1) = plot(...
%                     [model2.pts(edges(e,1),1),model2.pts(edges(e,2),1)], ...
%                     [model2.pts(edges(e,1),2),model2.pts(edges(e,2),2)], ...
%                     '-r', 'LineWidth', 1.5, 'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
            end
        end
       % for ii=1:size(model2.pts,1)
       %     handlelH(length(handlelH)+1) = plot(model2.pts(ii,1), model2.pts(ii,2),'.r');
       % end
        handlelH(length(handlelH)+1) = plot(model2.pts(:,1), model2.pts(:,2),'.r');
        hold off
        if isfield(pdm,'tri')
            if ~isempty(pdm.tri)
                hold on
                if exist('triplot_handles')
                    if ishandle(triplot_handles)
                        delete(triplot_handles)
                    end
                end
                triplot_handles=triplot(pdm.tri,model2.pts(:,1), model2.pts(:,2),'white');
                hold off
            end
        else
            if ishandle(triplot_handles)
                delete(triplot_handles)
            end
        end
    else
        for e = 1:size(setedges,1)
            set(handlelH(e),...
                'XData',[model2.pts(setedges(e,1),1),model2.pts(setedges(e,2),1)], ...
                'YData',[model2.pts(setedges(e,1),2),model2.pts(setedges(e,2),2)]);
        end
        if ishandle(handlelH(end))
            set(handlelH(end),...
                'XData',model2.pts(:,1), ...
                'YData',model2.pts(:,2));
        else
            handlelH(length(handlelH)) = plot(model2.pts(:,1), model2.pts(:,2),'.r');
        end
        if isfield(pdm,'tri')
            if ~isempty(pdm.tri)
                if exist('triplot_handles')
                    if ishandle(triplot_handles)
                        delete(triplot_handles)
                    end
                end
                hold on
                triplot_handles=triplot(pdm.tri,model2.pts(:,1), model2.pts(:,2),'white');
                hold off
            end
        else
            if ishandle(triplot_handles)
                delete triplot_handles
            end
        end
    end
    axis('ij')
    Xm = reshape(pdm.Xm, 2, length(pdm.Xm)/2)';
    %axis([min(Xm(:,1))-10, max(Xm(:,1))+10, min(Xm(:,2))-10, max(Xm(:,2))+10 ]);
end
