function [output] = modelBuilder3DToolVolViewer(AAMShapemodel_figure_handle)
    % modelBuilder3DTool M-file for modelBuilder3DTool.fig
    %
    % Description:
    %
    %
    % Author: Andrew Bangham
    % Date: 2012
    Data = guidata(AAMShapemodel_figure_handle);
    % ensure that the MSR structure is consistent with the AAM structure
    if isfield(Data,'TemplateMSR')
        ThereIsTemplateMSR=true;
    else
        ThereIsTemplateMSR=false;
    end
    pmt=get(Data.handles.AAM,'PointModelTemplate');
    if ~isempty(pmt)
        pts=get(pmt,'pts');
        if ~isempty(pts)
            ThereIsTemplateAAM=true;
        else
            ThereIsTemplateAAM=false;
        end
    else
        ThereIsTemplateAAM=false;
    end
    if ThereIsTemplateAAM && ~ThereIsTemplateMSR % create MSR from AAM
        Data
    elseif ~ThereIsTemplateAAM && ThereIsTemplateMSR % create AAM from MSR
    elseif ThereIsTemplateAAM && ThereIsTemplateMSR % invite the user to choose which is the master
    else % create a new template using MSR
    end
        % do you want to adopt the MSR data rather than the AAM data?
    disp('To be done');
    % put the data structure back into the main work flow control window
    guidata(AAMShapemodel_figure_handle,Data);
end
